#---------------------------------------------
#!/usr/std/bin/python

from Tkinter import *
import Tkinter
import tkMessageBox, tkFileDialog
import thread
import os, sys
import Pmw 
from sys import *

esdc_path = os.getenv("ESDC")
flusol_path = esdc_path + "\gui"
flusol_lib = flusol_path  + "\lib"
gmsh_path = esdc_path + "\gmsh"
python_path = esdc_path + "\Python24"
sys.path[:0] = [esdc_path,flusol_path,flusol_lib,gmsh_path]

def d1_run():
    thread.start_new_thread(run_1d, ())
       
def run_1d():
    #tt = "c:\esdc\Python24\python < " + flusol_lib + r"\one_d_mesh.py"
    tt = python_path  + "\python < " + flusol_lib + r"\one_d_mesh.py"
    #print "1d, tt=",tt
    os.system(tt)

def patch_run():
    thread.start_new_thread(run_patch, ())
       
def run_patch():
    #tt = "c:\esdc\Python24\python < " + flusol_lib + r"\patch.py"
    tt = python_path  + "\python < " + flusol_lib + r"\patch.py"
    print "patch, tt=",tt
    os.system(tt)

def circle_run():
    thread.start_new_thread(run_circle, ())
       
def run_circle():
    tt = python_path  + "\python < " + flusol_lib + r"\circle.py"
    os.system(tt)

def ellipse_run():
    thread.start_new_thread(run_ellipse, ())
       
def run_ellipse():
    tt = python_path  + "\python < " + flusol_lib + r"\ellipse.py"
    os.system(tt)
    
def duct_run():
    thread.start_new_thread(run_duct, ())

def run_duct():
    tt = python_path  + "\python < " + flusol_lib + r"\duct.py"
    os.system(tt)

def main():
   root = Tk()
   tk_rgb = "#%02x%02x%02x"%(198,198,198)
   bg = tk_rgb 
   frame=Frame(root, borderwidth=3, padx=3, pady=5) 
   frame1=Frame(frame, relief='groove', borderwidth=3, padx=3, pady=5)
   frame1.pack(side="top")   
   label_width = 20
   mesh_width = 10
      
      
          


      
#-------------------------------------------------------------------------
#frame for 2D mesh
#-------------------------------------------------------------------------
   frame_2d = Tkinter.Frame(frame, relief='groove', borderwidth=4
                           ,bg=bg
                           )
   frame_2d.pack(anchor='center', side = 'top')
   frame2= frame_2d
   label_width= 12
      
   krow = 0
   lbl = Label(frame2, text="1D Mesh Generation "
              ,font='*-Courier-Bold-R-Normal-*-20-*'
              , anchor='w'
              , justify='left'
              , foreground="blue"
              )
   lbl.grid(row=krow, column=0, columnspan = 3, sticky='nw')
   #1dlbl.configure(width="30")

   #empty line
   krow = krow + 1
   lbl_empty= Label(frame2, text="")
   lbl_empty.grid(row=krow, column=2, columnspan = 2, sticky='w')
   #lbl_empty.configure(width="30")
      
   #1D duct flow
   krow = krow + 1
   d1=Button(frame2, text="1D ",font=("Helvetica", 14))                    
   d1.configure(width=label_width
                      ,command= d1_run 
                      )
   d1.grid(row=krow, column=1, pady=3)

   krow = krow + 1
   self_2d= Label(frame2, text="2D & 3D Mesh Generation "
                 ,font='*-Courier-Bold-R-Normal-*-20-*'
                 , anchor='w'
                 , justify='left'
                 , foreground="blue"
                 )
   self_2d.grid(row=krow, column=0, columnspan = 2, sticky='nw')
   self_2d.configure(width=label_width )

   #Patch
   krow = krow + 1
   filename= flusol_lib + r"\node-4-2.gif"
   #print "filename =",filename
   img1a = PhotoImage(file=filename)
   w, h = img1a.width(), img1a.height()
   canv1 = Canvas(frame2, width=w, height=h)
   canv1.create_image(0, 0, anchor=NW, image=img1a)
   canv1.grid(row=krow, column=0)

   but_patch=Button(frame2
                   , text="Patch"
                   ,font=("Helvetica", 14)
                   , height=5
                   #, width=w
                   #, height=h
                   #, image=img1a
                   )                    
   but_patch.configure(width=label_width
                      ,command= patch_run 
                      )
   but_patch.grid(row=krow, column=1, pady=3)  
   #Circle
   krow = krow + 1
   filename= flusol_lib + r"\cir-4.gif"
   #print "filename =",filename
   img2a = PhotoImage(file=filename)
   w, h = img1a.width(), img1a.height()
   canv1 = Canvas(frame2, width=w, height=h)
   canv1.create_image(0, 0, anchor=NW, image=img2a)
   canv1.grid(row=krow, column=0)

   but_circle=Button(frame2, text="Circle",font=("Helvetica", 14)
                    , height=5
                    )                    
   but_circle.configure(width=label_width
                       ,command= circle_run 
                       )
   but_circle.grid(row=krow, column=1, pady=3)
   #Ellipse
   krow = krow + 1
   filename= flusol_lib + r"\elip-3.gif"
   #filename= flusol_lib + r"\ellipse-5.gif"
   #print "filename =",filename
   img3a = PhotoImage(file=filename)
   w, h = img1a.width(), img1a.height()
   canv1 = Canvas(frame2, width=w, height=h)
   canv1.create_image(0, 0, anchor=NW, image=img3a)
   canv1.grid(row=krow, column=0)

   but_ellipse=Button(frame2, text="Ellipse",font=("Helvetica", 14)
                      #,image = img3a 
                      , height=5)                   
   but_ellipse.configure(width=label_width
                        ,command= ellipse_run
                        )
   but_ellipse.grid(row=krow, column=1, pady=3)       
 
   '''krow = krow + 1
   filename= flusol_lib + r"\duct0.gif"
   #filename= flusol_lib + r"\duct0.gif"
   print "filename =",filename
   img4a = PhotoImage(file=filename)
   w, h = img1a.width(), img1a.height()
   canv_duct = Canvas(frame2, width=w, height=h)
   canv_duct.create_image(0, 0, anchor=NW, image=img4a)
   canv_duct.grid(row=krow, column=0)

   but_duct=Button(frame2, text="Duct",font=("Helvetica", 14)
                      #,image = im43a 
                      , height=5)                   
   but_duct.configure(width=label_width
                        ,command= duct_run
                        )
   but_duct.grid(row=krow, column=1, pady=3) '''      


   exitButton = Button(frame, text = 'Exit',command = root.destroy
                       , pady=3, font='*-Courier-Bold-R-Normal-*-14-*'
                       , bg=tk_rgb,width = 10, height=2)
   exitButton.pack(side="top")

   frame.pack()

   #root.geometry("%dx%d%+d%+d"%(1000,650,100,100))
   root.geometry("")
   tk_rgb = "#%02x%02x%02x"%(198,198,198)
   bg=tk_rgb
   #bg='white'

   fg='black'
   Pmw.Color.changecolor(root, bg, foreground = fg)

   title = 'FluSol MESH '
   root.title(title)

   root.mainloop()

main()
